
// Create Resource Descriptor
$instantResource = new ScriptObject()
{
   Class = "pauseWindowInactive";
   Name = "pauseWindowInactive";
   User = "TGB";
   LoadFunction = "pauseWindowInactive::LoadResource";
   UnloadFunction = "pauseWindowInactive::UnloadResource";
};
$instantResource.Data = $instantResource;

// Initialize to False.
$PauseWhenInactive = false;

// Load Resource Function - Hooks into game
function pauseWindowInactive::LoadResource( %this )
{
   $PauseWhenInactive = true;
}

// Unload Resource Function - Remove from game Sim.
function pauseWindowInactive::UnloadResource( %this )
{
   $PauseWhenInactive = false;
}

//---------------------------------------------------------------------------------------------
// windowFocusChanged
// Called when the gmae window
//---------------------------------------------------------------------------------------------
function windowFocusChanged( %isFocused ) 
{
   if( %isFocused ) 
      setSimTimeScale( 1.0 );
   else if( !%isFocused && $pauseWhenInactive == true )
      setSimTimeScale( 0.0 );
}